/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#include <vcl.h>
#include <math.h>
#include "FixPoly.h"
//---------------------------------------------------------------------------

float FindAngle(SplitPoint pos1, SplitPoint pos2)
{
  const double RADCONV = 57.295779513082;   // value from TI-86
           int x;

   x = (atan2(pos2.y - pos1.y, pos2.x - pos1.x) * RADCONV);
   if (x < 0)
    x += 360;

  return x;
}

float Distance(SplitPoint pos1, SplitPoint pos2)
{
  return sqrt((pos1.x - pos2.x)*(pos1.x - pos2.x) + (pos1.y - pos2.y)*(pos1.y - pos2.y));
}

int FindStartPoint(SplitPoly &poly)
{
  int i;
  int sp, ang;
  float j;
  bool fail;
  int type;

  for(sp = 0; sp < poly.points; sp++)
  {
    if ((fabs(poly.point[sp].x-poly.point[(sp + 1) % poly.points].x)<0.001)&&(fabs(poly.point[sp].y-poly.point[(sp + 1) % poly.points].y)<0.001))
       continue;
    ang = FindAngle(poly.point[sp], poly.point[(sp + 1) % poly.points]);
    fail = false;
    type=1;
    for(i = (sp + 1) % poly.points; i != sp; i = (i+1)%poly.points)
    {
      if ((fabs(poly.point[sp].x-poly.point[i].x)<0.001)&&(fabs(poly.point[sp].y-poly.point[i].y)<0.001))
        continue;
      j = FindAngle(poly.point[sp], poly.point[i]);
      float diff=j-ang;
      while (diff>180) diff-=360;
      while (diff<-180) diff+=360;
      if ((diff<0)&&(type==1))
      {
        fail = true;
        break;
      }
      else if ((diff>0)&&(type==-1))
      {
        fail = true;
        break;
      }
      ang = j;
      if (type==0)
          type=(diff<0)?-1:(diff>0)?1:0;
    }
    if (!fail)
      return sp;
  }

  return 0;
}

void FixPoly(SplitPolys &polys)
{
  int i, j, p, n, x,
      sp, dist;
  float d;
  bool split, dec;
  static SplitPoly temp;

  for(;;)
  {
    sp = FindStartPoint(polys.poly[0]);
    split = false;
    dec = false;
    dist = 0;
    p = polys.poly[0].points;
    for(i = (sp + 1) % p; i != sp; i = (i+1)%p)
    {
      d = Distance(polys.poly[0].point[sp], polys.poly[0].point[i]);
      if (d < dist)
        dec = true;
      else if ((dec == true) && (j >= dist))
      {
        i = ((i - 1) + p) % p;
        n = polys.polys++;
        if (n>=MAX_POLY_SPLITS)
            throw "Polygon split count exceeded maximum";
        polys.poly[n].points = 0;
        for(j = sp; j != i; j = (j+1)%p)
          polys.poly[n].point[polys.poly[n].points++] = polys.poly[0].point[j];
        polys.poly[n].point[polys.poly[n].points++] = polys.poly[0].point[j];
        if (polys.poly[n].points>=MAX_POLY_POINTS)
            throw "Polygon vertex count exceeded maximum";
        polys.poly[0].points = 0;
        temp.points = 0;
        for(j = i; j != sp; j = (j+1)%p)
          temp.point[temp.points++] = polys.poly[0].point[j];
        temp.point[temp.points++] = polys.poly[0].point[j];
        if (temp.points>=MAX_POLY_POINTS)
            throw "Polygon vertex count exceeded maximum";
        polys.poly[0]=temp;
        split = true;
        break;
      }
      dist = d;
    }
    if (!split)
      return;
  }
}

/*void __fastcall TForm1::Run1Click(TObject *Sender)
{
  Poly poly;
  Polys polys;
  int i;

  poly.points = 7;
  poly.point[0] = Point(0,0);
  poly.point[1] = Point(100,0);
  poly.point[2] = Point(75,25);
  poly.point[3] = Point(100,50);
  poly.point[4] = Point(50,75);
  poly.point[5] = Point(50,50);
  poly.point[6] = Point(0,100);

  polys.polys = 1;
  polys.poly[0] = poly;

  DrawPoly(polys.poly[0], 0, 0);

  FixPoly(polys);

  for(i = 0; i < polys.polys; i++)
    DrawPoly(polys.poly[i], i * 200, 200);
}*/
//---------------------------------------------------------------------------
